package cool.taomu.box.oltu.service;

import org.apache.commons.lang3.StringUtils;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ClientService {
  public OAuthJSONAccessTokenResponse requestToken(final String authServerUrl, final String resourceUrl, final String code, final String clientId, final String clientSecret) {
    try {
      URLConnectionClient _uRLConnectionClient = new URLConnectionClient();
      OAuthClient oAuthClient = new OAuthClient(_uRLConnectionClient);
      OAuthClientRequest.TokenRequestBuilder req = OAuthClientRequest.tokenLocation(authServerUrl);
      req.setClientId(clientId);
      req.setClientSecret(clientSecret);
      req.setGrantType(GrantType.AUTHORIZATION_CODE);
      req.setCode(code);
      req.setRedirectURI(StringUtils.<String>defaultIfEmpty(resourceUrl, "http://localhost:8080"));
      return oAuthClient.accessToken(req.buildQueryMessage(), OAuth.HttpMethod.POST);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
