package cool.taomu.box.oltu.service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.oltu.oauth2.as.issuer.MD5Generator;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.request.OAuthAuthzRequest;
import org.apache.oltu.oauth2.as.request.OAuthTokenRequest;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ServerService {
  public interface ICode {
    String getCode(final String cliengId);
  }
  
  public interface IToken {
    boolean isCode(final String code, final String cliengId, final String secret);
  }
  
  public String OwnerCode(final HttpServletRequest request, final ServerService.ICode code) {
    try {
      String result = "";
      OAuthAuthzRequest req = new OAuthAuthzRequest(request);
      boolean _isNotEmpty = StringUtils.isNotEmpty(req.getClientId());
      if (_isNotEmpty) {
        String id = req.getClientId();
        OAuthASResponse.OAuthAuthorizationResponseBuilder builder = OAuthASResponse.authorizationResponse(request, HttpServletResponse.SC_FOUND);
        builder.setCode(code.getCode(id));
        String redirectURI = req.getParam(OAuth.OAUTH_REDIRECT_URI);
        OAuthResponse resp = builder.location(redirectURI).buildQueryMessage();
        result = resp.getLocationUri();
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String getToken(final HttpServletRequest request, final ServerService.IToken token) {
    try {
      String result = "{}";
      OAuthTokenRequest req = new OAuthTokenRequest(request);
      String clientId = req.getClientId();
      String clientSecret = req.getClientSecret();
      boolean _isCode = token.isCode(req.getCode(), clientId, clientSecret);
      if (_isCode) {
        boolean _isNoneEmpty = StringUtils.isNoneEmpty(clientId, clientSecret);
        if (_isNoneEmpty) {
          MD5Generator _mD5Generator = new MD5Generator();
          OAuthIssuerImpl issuer = new OAuthIssuerImpl(_mD5Generator);
          OAuthASResponse.OAuthTokenResponseBuilder resp = OAuthASResponse.tokenResponse(HttpServletResponse.SC_OK);
          resp.setAccessToken(issuer.accessToken());
          resp.setRefreshToken(issuer.refreshToken());
          resp.setExpiresIn("1000");
          result = resp.buildJSONMessage().getBody();
        }
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
