package cool.taomu.box.paho.mqtt.client.utils;

import cool.taomu.box.crypto.Base64;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import javax.inject.Inject;

@SuppressWarnings("all")
public class MqttCrypto implements IMqttCrypto {
  @Inject
  private ISerializationUtils util;
  
  @Override
  public byte[] encode(final DataStructureEntity payload) {
    byte[] dse = this.util.serialize(payload);
    return new Base64(dse).encode();
  }
  
  @Override
  public DataStructureEntity decode(final byte[] content) {
    byte[] decode = new Base64(content).decode();
    return this.util.<DataStructureEntity>deserialize(decode);
  }
}
