/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.paho.mqtt.client.utils;

import cool.taomu.box.crypto.Base64;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import javax.inject.Inject;

@SuppressWarnings("all")
public class MqttCrypto implements IMqttCrypto {
  @Inject
  private ISerializationUtils util;
  
  @Override
  public byte[] encode(final DataStructureEntity payload) {
    byte[] dse = this.util.serialize(payload);
    return new Base64(dse).encode();
  }
  
  @Override
  public DataStructureEntity decode(final byte[] content) {
    byte[] decode = new Base64(content).decode();
    return this.util.<DataStructureEntity>deserialize(decode);
  }
}
