/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.paho.mqtt.client;

import cool.taomu.box.paho.mqtt.client.MqttCallbackExtend;
import cool.taomu.box.paho.mqtt.client.utils.MqttCrypto;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsMqttClientCallback
extends MqttCallbackExtend
implements MqttCallback {
    private static Logger LOG = LoggerFactory.getLogger(AbsMqttClientCallback.class);
    private MqttClient client;
    private MqttConnectOptions options;
    @Inject
    private MqttCrypto crypto;

    public void connectionLost(Throwable cause) {
        LOG.debug("\u8fde\u63a5\u4e22\u5931", cause);
        this.reconnect(this.client, this.options);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        Consumer<String> _function = it -> LOG.debug("Client deliveryComplete : {}", it);
        ((List)Conversions.doWrapArray((Object)token.getTopics())).forEach(_function);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        DataStructureEntity msg = this.crypto.decode(message.getPayload());
        this.message(msg);
    }

    public abstract void message(DataStructureEntity var1);
}

