/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.paho.mqtt.client;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.paho.mqtt.client.QoS;
import cool.taomu.box.paho.mqtt.client.TopicEntity;
import cool.taomu.box.paho.mqtt.client.WillEntity;
import cool.taomu.box.paho.mqtt.client.utils.MqttCrypto;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MqttClientV3 {
    @Inject
    @Named(value="taomubox.mqtt.client.host")
    private String host;
    @Inject
    @Named(value="taomubox.mqtt.client.port")
    private int port;
    @Inject
    @Named(value="taomubox.mqtt.client.id")
    private String clientId;
    @Inject(optional=true)
    @Named(value="taomubox.mqtt.client.password")
    private String password;
    @Inject
    private MqttCrypto crypto;

    public void subscriber(final TopicEntity topic, MqttCallback callback) {
        try {
            boolean _tripleNotEquals;
            final MemoryPersistence memoryPersistence = new MemoryPersistence();
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setMqttVersion(4);
            mqttConnectOptions.setCleanSession(topic.isCleanSession());
            if (this.clientId != null && !this.clientId.trim().equals("")) {
                mqttConnectOptions.setUserName(this.clientId);
                mqttConnectOptions.setPassword(this.password.toCharArray());
            }
            mqttConnectOptions.setConnectionTimeout(topic.getTimeout());
            mqttConnectOptions.setKeepAliveInterval(topic.getKeepAlive());
            WillEntity _will = topic.getWill();
            boolean bl = _tripleNotEquals = _will != null;
            if (_tripleNotEquals) {
                mqttConnectOptions.setWill(topic.getWill().getTopic(), topic.getWill().getMessage().getBytes("UTF-8"), topic.getWill().getQos(), topic.getWill().isRetain());
            }
            String _xifexpression = null;
            boolean _isSsl = topic.isSsl();
            _xifexpression = _isSsl ? "ssl" : "tcp";
            String broker = String.format("%s://%s:%d", _xifexpression, this.host, this.port);
            System.err.println(broker);
            String uuid = this.clientId;
            final MqttClient mqttClient = new MqttClient(broker, uuid, (MqttClientPersistence)memoryPersistence);
            mqttClient.setCallback(callback);
            mqttClient.connect(mqttConnectOptions);
            ArrayList<Integer> qoss = new ArrayList<Integer>();
            Functions.Function1 _function = it -> it.ordinal();
            qoss.addAll(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)topic.getQos())), (Functions.Function1)_function));
            for (int i = 0; qoss.size() < ((List)Conversions.doWrapArray((Object)topic.getValue())).size() && i < ((List)Conversions.doWrapArray((Object)topic.getValue())).size() - qoss.size(); ++i) {
                qoss.add(QoS.AT_MOST_ONCE.ordinal());
            }
            ArrayList<Integer> _converted_qoss = qoss;
            mqttClient.subscribe(topic.getValue(), (int[])Conversions.unwrapArray(_converted_qoss, Integer.TYPE));
            Runtime _runtime = Runtime.getRuntime();
            _runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        mqttClient.unsubscribe(topic.getValue());
                        mqttClient.disconnect();
                        memoryPersistence.close();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            });
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void sender(TopicEntity topic, DataStructureEntity payload) {
        block15: {
            try (MemoryPersistence memoryPersistence = new MemoryPersistence();){
                MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                mqttConnectOptions.setMqttVersion(4);
                mqttConnectOptions.setCleanSession(true);
                if (this.clientId != null) {
                    mqttConnectOptions.setUserName(this.clientId);
                    mqttConnectOptions.setPassword(this.password.toCharArray());
                }
                mqttConnectOptions.setConnectionTimeout(topic.getTimeout());
                mqttConnectOptions.setKeepAliveInterval(20);
                topic.setClientId(this.clientId);
                String _xifexpression = null;
                boolean _isSsl = topic.isSsl();
                _xifexpression = _isSsl ? "ssl" : "tcp";
                String _format = String.format("%s://%s:%d", _xifexpression, this.host, this.port);
                String _clientId = topic.getClientId();
                MqttClient mqttClient = new MqttClient(_format, _clientId, (MqttClientPersistence)memoryPersistence);
                mqttClient.connect(mqttConnectOptions);
                byte[] _encode = this.crypto.encode(payload);
                MqttMessage mqttMessage = new MqttMessage(_encode);
                mqttMessage.setQos(topic.getQos()[0].ordinal());
                mqttMessage.setRetained(topic.isRetain());
                mqttClient.publish(topic.getValue()[0], mqttMessage);
                mqttClient.disconnect();
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) break block15;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }
}

