/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.paho.mqtt.client;

import cool.taomu.box.paho.mqtt.client.utils.MqttCrypto;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public abstract class AbsMqttClientCallback extends MqttCallbackExtend implements MqttCallback {
  private static Logger LOG = LoggerFactory.getLogger(AbsMqttClientCallback.class);
  
  private MqttClient client;
  
  private MqttConnectOptions options;
  
  /**
   * @Inject
   * @Named("host")
   * String host;
   * @Inject
   * @Named("port")
   * int port;
   * @Inject
   * @Named("uname")
   * String username;
   * @Inject
   * @Named("passwd")
   * String password;
   * 
   * ISerializationUtils isu;
   */
  @Inject
  private MqttCrypto crypto;
  
  @Override
  public void connectionLost(final Throwable cause) {
    AbsMqttClientCallback.LOG.debug("连接丢失", cause);
    this.reconnect(this.client, this.options);
  }
  
  @Override
  public void deliveryComplete(final IMqttDeliveryToken token) {
    final Consumer<String> _function = (String it) -> {
      AbsMqttClientCallback.LOG.debug("Client deliveryComplete : {}", it);
    };
    ((List<String>)Conversions.doWrapArray(token.getTopics())).forEach(_function);
  }
  
  @Override
  public void messageArrived(final String topic, final MqttMessage message) throws Exception {
    DataStructureEntity msg = this.crypto.decode(message.getPayload());
    this.message(msg);
  }
  
  public abstract void message(final DataStructureEntity entity);
}
