package cool.taomu.box.paho.mqtt.client;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.paho.mqtt.client.utils.MqttCrypto;
import cool.taomu.box.task.dataentity.DataStructureEntity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class MqttClientV3 {
  @Inject
  @Named("taomubox.mqtt.client.host")
  private String host;
  
  @Inject
  @Named("taomubox.mqtt.client.port")
  private int port;
  
  @Inject
  @Named("taomubox.mqtt.client.id")
  private String clientId;
  
  @Inject(optional = true)
  @Named("taomubox.mqtt.client.password")
  private String password;
  
  @Inject
  private MqttCrypto crypto;
  
  public void subscriber(final TopicEntity topic, final MqttCallback callback) {
    try {
      final MemoryPersistence memoryPersistence = new MemoryPersistence();
      final MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
      mqttConnectOptions.setMqttVersion(MqttConnectOptions.MQTT_VERSION_3_1_1);
      mqttConnectOptions.setCleanSession(topic.isCleanSession());
      if (((this.clientId != null) && (!this.clientId.trim().equals("")))) {
        mqttConnectOptions.setUserName(this.clientId);
        mqttConnectOptions.setPassword(this.password.toCharArray());
      }
      mqttConnectOptions.setConnectionTimeout(topic.getTimeout());
      mqttConnectOptions.setKeepAliveInterval(topic.getKeepAlive());
      WillEntity _will = topic.getWill();
      boolean _tripleNotEquals = (_will != null);
      if (_tripleNotEquals) {
        mqttConnectOptions.setWill(topic.getWill().getTopic(), topic.getWill().getMessage().getBytes("UTF-8"), topic.getWill().getQos(), 
          topic.getWill().isRetain());
      }
      String _xifexpression = null;
      boolean _isSsl = topic.isSsl();
      if (_isSsl) {
        _xifexpression = "ssl";
      } else {
        _xifexpression = "tcp";
      }
      String broker = String.format("%s://%s:%d", _xifexpression, this.host, Integer.valueOf(this.port));
      System.err.println(broker);
      String uuid = this.clientId;
      final MqttClient mqttClient = new MqttClient(broker, uuid, memoryPersistence);
      mqttClient.setCallback(callback);
      mqttClient.connect(mqttConnectOptions);
      ArrayList<Integer> qoss = new ArrayList<Integer>();
      final Function1<QoS, Integer> _function = (QoS it) -> {
        return Integer.valueOf(it.ordinal());
      };
      qoss.addAll(ListExtensions.<QoS, Integer>map(((List<QoS>)Conversions.doWrapArray(topic.getQos())), _function));
      for (int i = 0; ((qoss.size() < ((List<String>)Conversions.doWrapArray(topic.getValue())).size()) && (i < (((List<String>)Conversions.doWrapArray(topic.getValue())).size() - qoss.size()))); i++) {
        qoss.add(Integer.valueOf(QoS.AT_MOST_ONCE.ordinal()));
      }
      final ArrayList<Integer> _converted_qoss = (ArrayList<Integer>)qoss;
      mqttClient.subscribe(topic.getValue(), ((int[])Conversions.unwrapArray(_converted_qoss, int.class)));
      Runtime _runtime = Runtime.getRuntime();
      _runtime.addShutdownHook(new Thread() {
        @Override
        public void run() {
          try {
            mqttClient.unsubscribe(topic.getValue());
            mqttClient.disconnect();
            memoryPersistence.close();
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      });
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void sender(final TopicEntity topic, final DataStructureEntity payload) {
    try (MemoryPersistence memoryPersistence = new MemoryPersistence()) {
      MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
      mqttConnectOptions.setMqttVersion(MqttConnectOptions.MQTT_VERSION_3_1_1);
      mqttConnectOptions.setCleanSession(true);
      if ((this.clientId != null)) {
        mqttConnectOptions.setUserName(this.clientId);
        mqttConnectOptions.setPassword(this.password.toCharArray());
      }
      mqttConnectOptions.setConnectionTimeout(topic.getTimeout());
      mqttConnectOptions.setKeepAliveInterval(20);
      topic.setClientId(this.clientId);
      String _xifexpression = null;
      boolean _isSsl = topic.isSsl();
      if (_isSsl) {
        _xifexpression = "ssl";
      } else {
        _xifexpression = "tcp";
      }
      String _format = String.format("%s://%s:%d", _xifexpression, this.host, Integer.valueOf(this.port));
      String _clientId = topic.getClientId();
      MqttClient mqttClient = new MqttClient(_format, _clientId, memoryPersistence);
      mqttClient.connect(mqttConnectOptions);
      byte[] _encode = this.crypto.encode(payload);
      MqttMessage mqttMessage = new MqttMessage(_encode);
      mqttMessage.setQos((topic.getQos()[0]).ordinal());
      mqttMessage.setRetained(topic.isRetain());
      mqttClient.publish(topic.getValue()[0], mqttMessage);
      mqttClient.disconnect();
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
