/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.redis.lock;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class RedisLock extends AbsLock {
  private static Logger LOG = LoggerFactory.getLogger(RedisLock.class);
  
  @Inject
  private RedissonClient rClient;
  
  private RLock lock;
  
  @Override
  public void lock() {
    String uuid = UUID.randomUUID().toString();
    this.lock = this.rClient.getLock(uuid);
    this.lock.lock();
    RedisLock.LOG.info("添加锁");
  }
  
  @Override
  public boolean tryLock() {
    boolean ret = false;
    try {
      ret = this.tryLock(60, TimeUnit.SECONDS);
    } catch (final Throwable _t) {
      if (_t instanceof InterruptedException) {
        final InterruptedException e = (InterruptedException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return ret;
  }
  
  @Override
  public boolean tryLock(final long arg0, final TimeUnit arg1) throws InterruptedException {
    String uuid = UUID.randomUUID().toString();
    this.lock = this.rClient.getLock(uuid);
    this.lock.lock(arg0, arg1);
    RedisLock.LOG.info("添加锁");
    return this.lock.isLocked();
  }
  
  @Override
  public void unlock() {
    boolean _isLocked = this.lock.isLocked();
    if (_isLocked) {
      this.lock.unlock();
      RedisLock.LOG.info("释放锁");
    }
  }
  
  @Override
  public void lockInterruptibly() throws InterruptedException {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  @Override
  public Condition newCondition() {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
}
