/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.redis;

import com.google.inject.Provider;
import cool.taomu.box.inter.IDataSource;
import java.util.Collections;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

@SuppressWarnings("all")
public abstract class AbsRedisSentinelientPoolProvider implements Provider<IDataSource> {
  private final Logger LOG = LoggerFactory.getLogger(AbsRedisSentinelientPoolProvider.class);
  
  @Inject
  @Named("redis.database")
  private Integer database;
  
  @Inject
  @Named("redis.host")
  private String host;
  
  @Inject
  @Named("redis.port")
  private Integer port;
  
  @Inject
  @Named("redis.password")
  private String password;
  
  @Inject
  @Named("redis.username")
  private String username;
  
  @Inject
  @Named("redis.timeout")
  private Integer timeout;
  
  @Inject
  @Named("redis.master")
  private String master;
  
  public abstract void configure(final JedisPoolConfig poolConfig);
  
  @Override
  public IDataSource get() {
    JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
    this.configure(jedisPoolConfig);
    HashSet<String> nodeSet = new HashSet<String>();
    String[] _split = this.host.split(",");
    for (final String node : _split) {
      {
        this.LOG.info("sentinel host:{}", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(this.host, this.port)), ":"));
        nodeSet.add(IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(this.host, this.port)), ":"));
      }
    }
    JedisSentinelPool pool = null;
    if ((this.username == null)) {
      if ((this.password == null)) {
        JedisSentinelPool _jedisSentinelPool = new JedisSentinelPool(this.master, nodeSet, jedisPoolConfig, (this.timeout).intValue());
        pool = _jedisSentinelPool;
      } else {
        JedisSentinelPool _jedisSentinelPool_1 = new JedisSentinelPool(this.master, nodeSet, jedisPoolConfig, (this.timeout).intValue(), (this.timeout).intValue(), this.password, (this.database).intValue());
        pool = _jedisSentinelPool_1;
      }
    } else {
      if (((this.username != null) && (this.password != null))) {
        JedisSentinelPool _jedisSentinelPool_2 = new JedisSentinelPool(this.master, nodeSet, jedisPoolConfig, (this.timeout).intValue(), (this.timeout).intValue(), this.username, this.password, 
          (this.database).intValue());
        pool = _jedisSentinelPool_2;
      }
    }
    return new RedisSentinelDataSource(pool);
  }
}
