/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.redis;

import cool.taomu.box.inter.IDataSource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@SuppressWarnings("all")
public abstract class AbsRedisJedisPoolProvider implements Provider<IDataSource> {
  @Inject
  @Named("redis.host")
  private String host;
  
  @Inject
  @Named("redis.port")
  private Integer port;
  
  @Inject
  @Named("redis.password")
  private String password;
  
  @Inject
  @Named("redis.username")
  private String username;
  
  @Inject
  @Named("redis.timeout")
  private Integer timeout;
  
  public abstract void configure(final JedisPoolConfig poolConfig);
  
  @Override
  public IDataSource get() {
    JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
    this.configure(jedisPoolConfig);
    String password = this.password;
    String user = this.username;
    Integer timeout = this.timeout;
    JedisPool pool = null;
    if ((user == null)) {
      if ((password == null)) {
        JedisPool _jedisPool = new JedisPool(jedisPoolConfig, this.host, (this.port).intValue());
        pool = _jedisPool;
      } else {
        JedisPool _jedisPool_1 = new JedisPool(jedisPoolConfig, this.host, (this.port).intValue(), (timeout).intValue(), password);
        pool = _jedisPool_1;
      }
    } else {
      if (((user != null) && (password != null))) {
        JedisPool _jedisPool_2 = new JedisPool(jedisPoolConfig, this.host, (this.port).intValue(), (timeout).intValue(), user, password);
        pool = _jedisPool_2;
      }
    }
    return new RedisDataSource(pool);
  }
}
