package cool.taomu.box.redis.queue;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import redis.clients.jedis.Jedis;

@SuppressWarnings("all")
public class RedisQueue<T extends Serializable> extends AbstractQueue<T> implements BlockingQueue<T> {
  public static final class Itr<E extends Serializable> implements Iterator<E> {
    private final Object[] array;
    
    private int cursor;
    
    private int lastRet = (-1);
    
    public Itr(final Object[] array) {
      this.array = array;
    }
    
    @Override
    public boolean hasNext() {
      int _length = this.array.length;
      return (this.cursor < _length);
    }
    
    @Override
    public E next() {
      int _length = this.array.length;
      boolean _greaterEqualsThan = (this.cursor >= _length);
      if (_greaterEqualsThan) {
        throw new NoSuchElementException();
      }
      int _plusPlus = this.cursor++;
      int _lastRet = this.lastRet = _plusPlus;
      Object _get = this.array[_lastRet];
      String result = ((String) _get);
      return SerializationUtils.<E>deserialize(result.getBytes());
    }
    
    @Override
    public void remove() {
      if ((this.lastRet < 0)) {
        throw new IllegalStateException();
      }
      this.lastRet = (-1);
    }
    
    @Override
    public void forEachRemaining(final Consumer<? super E> action) {
      Objects.<Consumer<? super E>>requireNonNull(action);
      final Object[] es = this.array;
      int i = 0;
      int _i = (i = this.cursor);
      int _length = es.length;
      boolean _lessThan = (_i < _length);
      if (_lessThan) {
        this.lastRet = (-1);
        this.cursor = es.length;
        for (; (i < es.length); i++) {
          {
            Object _get = es[i];
            String result = ((String) _get);
            action.accept(SerializationUtils.<E>deserialize(result.getBytes()));
          }
        }
        int _length_1 = es.length;
        int _minus = (_length_1 - 1);
        this.lastRet = _minus;
      }
    }
  }
  
  private Jedis jedis;
  
  private String queueName = "Taomu-Redis-Network-Queue";
  
  public RedisQueue() {
  }
  
  public RedisQueue(final Jedis jedis) {
    this.jedis = jedis;
  }
  
  @Override
  public Spliterator<T> spliterator() {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  @Override
  public Iterator<T> iterator() {
    List<String> results = this.jedis.rpop(this.queueName, this.size());
    final List<String> _converted_results = (List<String>)results;
    this.jedis.rpush(this.queueName, ((String[])Conversions.unwrapArray(_converted_results, String.class)));
    final List<String> _converted_results_1 = (List<String>)results;
    return new RedisQueue.Itr<T>(((Object[])Conversions.unwrapArray(_converted_results_1, Object.class)));
  }
  
  @Override
  public int size() {
    long _llen = this.jedis.llen(this.queueName);
    return ((int) _llen);
  }
  
  @Override
  public boolean offer(final T e) {
    try {
      byte[] result = SerializationUtils.serialize(e);
      String _string = new String(result, "UTF-8");
      this.jedis.lpush(this.queueName, _string);
      return true;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public T peek() {
    String result = this.jedis.rpop(this.queueName);
    this.jedis.rpush(result);
    return SerializationUtils.<T>deserialize(result.getBytes());
  }
  
  @Override
  public T poll() {
    String result = this.jedis.brpop(0, this.queueName).get(0);
    return SerializationUtils.<T>deserialize(result.getBytes());
  }
  
  @Override
  public int drainTo(final Collection<? super T> c) {
    return this.drainTo(c, Integer.MAX_VALUE);
  }
  
  @Override
  public int drainTo(final Collection<? super T> c, final int maxElements) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  @Override
  public boolean offer(final T e, final long timeout, final TimeUnit unit) throws InterruptedException {
    return this.add(e);
  }
  
  @Override
  public T poll(final long timeout, final TimeUnit unit) throws InterruptedException {
    long _nanos = unit.toNanos(timeout);
    long nanos = (_nanos / 1000);
    String result = this.jedis.brpop(((int) nanos), this.queueName).get(0);
    return SerializationUtils.<T>deserialize(result.getBytes());
  }
  
  @Override
  public void put(final T e) throws InterruptedException {
    this.add(e);
  }
  
  @Override
  public int remainingCapacity() {
    return Integer.MAX_VALUE;
  }
  
  @Override
  public T take() throws InterruptedException {
    String result = this.jedis.brpop(0, this.queueName).get(0);
    return SerializationUtils.<T>deserialize(result.getBytes());
  }
}
