/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.redis.queue;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import redis.clients.jedis.Jedis;

public class RedisQueue<T extends Serializable>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private Jedis jedis;
    private String queueName = "Taomu-Redis-Network-Queue";

    public RedisQueue() {
    }

    public RedisQueue(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    @Override
    public Iterator<T> iterator() {
        List results;
        List _converted_results = results = this.jedis.rpop(this.queueName, this.size());
        this.jedis.rpush(this.queueName, (String[])Conversions.unwrapArray((Object)_converted_results, String.class));
        List _converted_results_1 = results;
        return new Itr((Object[])Conversions.unwrapArray((Object)_converted_results_1, Object.class));
    }

    @Override
    public int size() {
        long _llen = this.jedis.llen(this.queueName);
        return (int)_llen;
    }

    @Override
    public boolean offer(T e) {
        try {
            byte[] result = SerializationUtils.serialize(e);
            String _string = new String(result, "UTF-8");
            this.jedis.lpush(this.queueName, new String[]{_string});
            return true;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public T peek() {
        String result = this.jedis.rpop(this.queueName);
        this.jedis.rpush(result, new String[0]);
        return (T)((Serializable)SerializationUtils.deserialize((byte[])result.getBytes()));
    }

    @Override
    public T poll() {
        String result = (String)this.jedis.brpop(0, this.queueName).get(0);
        return (T)((Serializable)SerializationUtils.deserialize((byte[])result.getBytes()));
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.add(e);
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long _nanos = unit.toNanos(timeout);
        long nanos = _nanos / 1000L;
        String result = (String)this.jedis.brpop((int)nanos, this.queueName).get(0);
        return (T)((Serializable)SerializationUtils.deserialize((byte[])result.getBytes()));
    }

    @Override
    public void put(T e) throws InterruptedException {
        this.add(e);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public T take() throws InterruptedException {
        String result = (String)this.jedis.brpop(0, this.queueName).get(0);
        return (T)((Serializable)SerializationUtils.deserialize((byte[])result.getBytes()));
    }

    public static final class Itr<E extends Serializable>
    implements Iterator<E> {
        private final Object[] array;
        private int cursor;
        private int lastRet = -1;

        public Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            int _length = this.array.length;
            return this.cursor < _length;
        }

        @Override
        public E next() {
            int _plusPlus;
            boolean _greaterEqualsThan;
            int _length = this.array.length;
            boolean bl = _greaterEqualsThan = this.cursor >= _length;
            if (_greaterEqualsThan) {
                throw new NoSuchElementException();
            }
            int _lastRet = this.lastRet = (_plusPlus = this.cursor++);
            Object _get = this.array[_lastRet];
            String result = (String)_get;
            return (E)((Serializable)SerializationUtils.deserialize((byte[])result.getBytes()));
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            boolean _lessThan;
            Objects.requireNonNull(action);
            Object[] es = this.array;
            int i = 0;
            int _i = i = this.cursor;
            int _length = es.length;
            boolean bl = _lessThan = _i < _length;
            if (_lessThan) {
                int _minus;
                this.lastRet = -1;
                this.cursor = es.length;
                while (i < es.length) {
                    Object _get = es[i];
                    String result = (String)_get;
                    action.accept(SerializationUtils.deserialize((byte[])result.getBytes()));
                    ++i;
                }
                int _length_1 = es.length;
                this.lastRet = _minus = _length_1 - 1;
            }
        }
    }
}

