/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.redis;

import com.google.inject.Provider;
import cool.taomu.box.inter.IDataSource;
import cool.taomu.box.redis.RedisClusterDataSource;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public abstract class AbsRedisClusterClientProvider
implements Provider<IDataSource> {
    @Inject
    @Named(value="redis.host")
    private String host;
    @Inject
    @Named(value="redis.port")
    private Integer port;
    @Inject
    @Named(value="redis.password")
    private String password;
    @Inject
    @Named(value="redis.username")
    private String username;
    @Inject
    @Named(value="redis.timeout")
    private Integer timeout;
    @Inject
    @Named(value="redis.timeout")
    private int maxAttempts;
    private JedisCluster cluster;

    public abstract void configure(ConnectionPoolConfig var1);

    public IDataSource get() {
        ConnectionPoolConfig gopc = new ConnectionPoolConfig();
        this.configure(gopc);
        Integer timeout = this.timeout;
        int maxAttempts = this.maxAttempts;
        String password = this.password;
        String user = this.username;
        if (user == null) {
            if (password == null) {
                JedisCluster _jedisCluster;
                HostAndPort _hostAndPort = new HostAndPort(this.host, this.port.intValue());
                this.cluster = _jedisCluster = new JedisCluster(_hostAndPort, timeout.intValue(), timeout.intValue(), maxAttempts, (GenericObjectPoolConfig)gopc);
            } else {
                JedisCluster _jedisCluster_1;
                HostAndPort _hostAndPort_1 = new HostAndPort(this.host, this.port.intValue());
                this.cluster = _jedisCluster_1 = new JedisCluster(_hostAndPort_1, timeout.intValue(), timeout.intValue(), maxAttempts, password, (GenericObjectPoolConfig)gopc);
            }
        } else if (user != null && password != null) {
            JedisCluster _jedisCluster_2;
            HostAndPort _hostAndPort_2 = new HostAndPort(this.host, this.port.intValue());
            this.cluster = _jedisCluster_2 = new JedisCluster(_hostAndPort_2, timeout.intValue(), timeout.intValue(), maxAttempts, user, password, null, (GenericObjectPoolConfig)gopc);
        }
        Runtime _runtime = Runtime.getRuntime();
        _runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (AbsRedisClusterClientProvider.this.cluster != null) {
                    AbsRedisClusterClientProvider.this.cluster.close();
                }
            }
        });
        return new RedisClusterDataSource(this.cluster);
    }
}

