/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.redis;

import com.google.inject.Provider;
import cool.taomu.box.inter.IDataSource;
import cool.taomu.box.redis.RedisSentinelDataSource;
import java.util.Collections;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public abstract class AbsRedisSentinelientPoolProvider
implements Provider<IDataSource> {
    private final Logger LOG = LoggerFactory.getLogger(AbsRedisSentinelientPoolProvider.class);
    @Inject
    @Named(value="redis.database")
    private Integer database;
    @Inject
    @Named(value="redis.host")
    private String host;
    @Inject
    @Named(value="redis.port")
    private Integer port;
    @Inject
    @Named(value="redis.password")
    private String password;
    @Inject
    @Named(value="redis.username")
    private String username;
    @Inject
    @Named(value="redis.timeout")
    private Integer timeout;
    @Inject
    @Named(value="redis.master")
    private String master;

    public abstract void configure(JedisPoolConfig var1);

    public IDataSource get() {
        String[] _split;
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        this.configure(jedisPoolConfig);
        HashSet<String> nodeSet = new HashSet<String>();
        for (String node : _split = this.host.split(",")) {
            this.LOG.info("sentinel host:{}", (Object)IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{this.host, this.port})), (CharSequence)":"));
            nodeSet.add(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{this.host, this.port})), (CharSequence)":"));
        }
        JedisSentinelPool pool = null;
        if (this.username == null) {
            JedisSentinelPool _jedisSentinelPool_1;
            JedisSentinelPool _jedisSentinelPool;
            pool = this.password == null ? (_jedisSentinelPool = new JedisSentinelPool(this.master, nodeSet, (GenericObjectPoolConfig)jedisPoolConfig, this.timeout.intValue())) : (_jedisSentinelPool_1 = new JedisSentinelPool(this.master, nodeSet, (GenericObjectPoolConfig)jedisPoolConfig, this.timeout.intValue(), this.timeout.intValue(), this.password, this.database.intValue()));
        } else if (this.username != null && this.password != null) {
            JedisSentinelPool _jedisSentinelPool_2;
            pool = _jedisSentinelPool_2 = new JedisSentinelPool(this.master, nodeSet, (GenericObjectPoolConfig)jedisPoolConfig, this.timeout.intValue(), this.timeout.intValue(), this.username, this.password, this.database.intValue());
        }
        return new RedisSentinelDataSource((Pool<Jedis>)pool);
    }
}

