/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.redis;

import com.google.inject.Provider;
import cool.taomu.box.inter.IDataSource;
import javax.inject.Inject;
import javax.inject.Named;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@SuppressWarnings("all")
public abstract class AbsRedisClusterClientProvider implements Provider<IDataSource> {
  @Inject
  @Named("redis.host")
  private String host;
  
  @Inject
  @Named("redis.port")
  private Integer port;
  
  @Inject
  @Named("redis.password")
  private String password;
  
  @Inject
  @Named("redis.username")
  private String username;
  
  @Inject
  @Named("redis.timeout")
  private Integer timeout;
  
  @Inject
  @Named("redis.timeout")
  private int maxAttempts;
  
  private JedisCluster cluster;
  
  public abstract void configure(final ConnectionPoolConfig poolConfig);
  
  @Override
  public IDataSource get() {
    ConnectionPoolConfig gopc = new ConnectionPoolConfig();
    this.configure(gopc);
    Integer timeout = this.timeout;
    int maxAttempts = this.maxAttempts;
    String password = this.password;
    String user = this.username;
    if ((user == null)) {
      if ((password == null)) {
        HostAndPort _hostAndPort = new HostAndPort(this.host, (this.port).intValue());
        JedisCluster _jedisCluster = new JedisCluster(_hostAndPort, (timeout).intValue(), (timeout).intValue(), maxAttempts, gopc);
        this.cluster = _jedisCluster;
      } else {
        HostAndPort _hostAndPort_1 = new HostAndPort(this.host, (this.port).intValue());
        JedisCluster _jedisCluster_1 = new JedisCluster(_hostAndPort_1, (timeout).intValue(), (timeout).intValue(), maxAttempts, password, gopc);
        this.cluster = _jedisCluster_1;
      }
    } else {
      if (((user != null) && (password != null))) {
        HostAndPort _hostAndPort_2 = new HostAndPort(this.host, (this.port).intValue());
        JedisCluster _jedisCluster_2 = new JedisCluster(_hostAndPort_2, (timeout).intValue(), (timeout).intValue(), maxAttempts, user, password, null, gopc);
        this.cluster = _jedisCluster_2;
      }
    }
    Runtime _runtime = Runtime.getRuntime();
    _runtime.addShutdownHook(new Thread() {
      @Override
      public void run() {
        if ((AbsRedisClusterClientProvider.this.cluster != null)) {
          AbsRedisClusterClientProvider.this.cluster.close();
        }
      }
    });
    return new RedisClusterDataSource(this.cluster);
  }
}
