/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.redis.lock;

import javax.inject.Provider;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;

/**
 * 主从模式
 */
@SuppressWarnings("all")
public abstract class RedissonClientMasterSlaveProvider implements Provider<RedissonClient> {
  public abstract void configure(final MasterSlaveServersConfig config);
  
  @Override
  public RedissonClient get() {
    Config rconfig = new Config();
    MasterSlaveServersConfig rss = rconfig.useMasterSlaveServers();
    this.configure(rss);
    RedissonClient rClient = Redisson.create(rconfig);
    return rClient;
  }
}
