/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.script;

import java.util.List;

@SuppressWarnings("all")
public abstract class AbsScriptClassLoader extends ClassLoader implements AutoCloseable {
  public void init(final List<String> paths) {
    this.init(paths, Thread.currentThread().getContextClassLoader());
  }
  
  public abstract void init(final List<String> paths, final ClassLoader loader);
  
  public void loaderScript(final String src) {
    this.loaderScript(src, Thread.currentThread().getContextClassLoader());
  }
  
  public void loaderScript(final String src, final ClassLoader loader) {
    this.loaderScript(src, 0, loader);
  }
  
  public abstract void loaderScript(final String src, final int lineon, final ClassLoader loader);
  
  public Object invoke(final String name, final Object... args) {
    return this.invoke("", name, null, args);
  }
  
  public abstract Object invoke(final String zlassName, final String methodName, final Class<?>[] paramTypes, final Object... args);
}
