/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.script.dsl;

/**
 * @startuml
 * load -> script :加载脚本
 * note right
 * Dsl {
 *  load test.js
 *  call test,#[params]
 *  ret test
 * }
 * Dsl {
 *  name "etl"
 *  SSH_config {
 * 	 	uname ENC("")
 *  	upass ENC("")
 * 	}
 *  zvcf src,etl.core.tar.gz
 *  pscp etl.core.tar.gz,dest
 *  zcvf src,tag.tar.gz
 *  pscp tag.tar.gz,dest
 *  shell #[
 *  		"tar xvf etl.core.tar.gz -C ./tag",
 *  		"tar xvf tag.tar.gz -C ./tag",
 * 			"cd ./tag",
 * 			"sh tag.sh"
 *       ]
 * 	gscp /opt/app/ETL/DATA/BSS/20240101/*,dest
 *  }
 * }
 * end note
 * script-->load
 * load -> script : 调用脚本中的方法
 * script-->load
 * @enduml
 */
@SuppressWarnings("all")
public class TaomuDsl {
  public enum Type {
    JavaScript,
    
    Groovy,
    
    Bsh,
    
    Jython,
    
    JRuby;
  }
  
  public void load(final String filename) {
  }
  
  public void call(final String callName, final Object[] args) {
  }
  
  public void ret(final String name) {
  }
}
