package cool.taomu.box.script;

import java.util.List;

@SuppressWarnings("all")
public abstract class AbsScriptClassLoader extends ClassLoader implements AutoCloseable {
  public void init(final List<String> paths) {
    this.init(paths, Thread.currentThread().getContextClassLoader());
  }
  
  public abstract void init(final List<String> paths, final ClassLoader loader);
  
  public void loaderScript(final String src) {
    this.loaderScript(src, Thread.currentThread().getContextClassLoader());
  }
  
  public void loaderScript(final String src, final ClassLoader loader) {
    this.loaderScript(src, 0, loader);
  }
  
  public abstract void loaderScript(final String src, final int lineon, final ClassLoader loader);
  
  public Object invoke(final String name, final Object... args) {
    return this.invoke("", name, null, args);
  }
  
  public abstract Object invoke(final String zlassName, final String methodName, final Class<?>[] paramTypes, final Object... args);
}
