package cool.taomu.box.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class GroovyDsl {
  public static Object dsl(final File file, final Map<String, Object> params) {
    try {
      ClassLoader _classLoader = GroovyScriptEngineImpl.class.getClassLoader();
      GroovyShell shell = new GroovyShell(_classLoader);
      Script script = shell.parse(file);
      final Binding binding = new Binding();
      if (((params != null) && (!params.isEmpty()))) {
        final Consumer<Map.Entry<String, Object>> _function = (Map.Entry<String, Object> it) -> {
          binding.setProperty(it.getKey(), it.getValue());
        };
        params.entrySet().forEach(_function);
      }
      return InvokerHelper.createScript(script.getClass(), binding).run();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Object dsl(final Vector<InputStream> inputs, final Map<String, Object> params) {
    return GroovyDsl.dsl(inputs, "", params);
  }
  
  public static Object dsl(final Vector<InputStream> inputs, final String filename, final Map<String, Object> params) {
    try {
      Enumeration<InputStream> _elements = inputs.elements();
      SequenceInputStream input = new SequenceInputStream(_elements);
      ClassLoader _classLoader = GroovyScriptEngineImpl.class.getClassLoader();
      GroovyShell shell = new GroovyShell(_classLoader);
      String text = IOUtils.toString(input, "UTF-8");
      Script _xifexpression = null;
      boolean _equals = filename.equals("");
      if (_equals) {
        _xifexpression = shell.parse(text);
      } else {
        _xifexpression = shell.parse(text, filename);
      }
      Script script = _xifexpression;
      final Binding binding = new Binding();
      if (((params != null) && (!params.isEmpty()))) {
        final Consumer<Map.Entry<String, Object>> _function = (Map.Entry<String, Object> it) -> {
          binding.setProperty(it.getKey(), it.getValue());
        };
        params.entrySet().forEach(_function);
      }
      return InvokerHelper.createScript(script.getClass(), binding).run();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static Object dsl(final InputStream input, final Map<String, Object> params) {
    try {
      ClassLoader _classLoader = GroovyScriptEngineImpl.class.getClassLoader();
      GroovyShell shell = new GroovyShell(_classLoader);
      String text = IOUtils.toString(input, "UTF-8");
      Script script = shell.parse(text);
      final Binding binding = new Binding();
      if (((params != null) && (!params.isEmpty()))) {
        final Consumer<Map.Entry<String, Object>> _function = (Map.Entry<String, Object> it) -> {
          binding.setProperty(it.getKey(), it.getValue());
        };
        params.entrySet().forEach(_function);
      }
      return InvokerHelper.createScript(script.getClass(), binding).run();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    File _file = new File("./usecase/dsl.groovy");
    GroovyDsl.dsl(_file, null);
  }
}
