/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.stock;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class StockUtils {
    public static double sma(List<Object> closePrice, int periodsAverage) {
        double sum = 0.0;
        for (int i = closePrice.size() - periodsAverage; i < closePrice.size(); ++i) {
            double _sum = sum;
            Object _get = closePrice.get(i);
            sum = _sum + (Double)_get;
        }
        Double res = Double.valueOf(String.format("%.2f", sum / (double)periodsAverage));
        return res;
    }

    public static double ema(List<Object> closePrice, int period) {
        Double k = 2.0 / ((double)period + 1.0);
        Object _get = closePrice.get(0);
        Double ema = (Double)_get;
        for (int i = 1; i < closePrice.size(); ++i) {
            Object _get_1 = closePrice.get(i);
            double _multiply = DoubleExtensions.operator_multiply((Double)((Double)_get_1), (Number)k);
            double _plus = _multiply + ema * (1.0 - k);
            ema = _plus;
        }
        return ema;
    }

    public static MacdData macd(List<Object> closePrice, int shortPeriod, int longPeriod, int midPeriod) {
        ArrayList<Object> diffList = new ArrayList<Object>();
        double shortEma = 0.0;
        double longEma = 0.0;
        double dif = 0.0;
        double dea = 0.0;
        for (int i = closePrice.size() - 1; i >= 0; --i) {
            int _size = closePrice.size();
            int _minus = _size - i;
            List<Object> sublist = closePrice.subList(0, _minus);
            shortEma = StockUtils.ema(sublist, shortPeriod);
            longEma = StockUtils.ema(sublist, longPeriod);
            dif = shortEma - longEma;
            diffList.add(dif);
        }
        dea = StockUtils.ema(diffList, midPeriod);
        dif = Double.valueOf(String.format("%.2f", dif));
        dea = Double.valueOf(String.format("%.2f", dea));
        MacdData data = new MacdData();
        data.dif = dif;
        data.dea = dea;
        data.macd = Double.valueOf(String.format("%.2f", (dif - dea) * 2.0));
        return data;
    }

    @Accessors
    public static class MacdData {
        private double dif;
        private double dea;
        private double macd;

        @Pure
        public double getDif() {
            return this.dif;
        }

        public void setDif(double dif) {
            this.dif = dif;
        }

        @Pure
        public double getDea() {
            return this.dea;
        }

        public void setDea(double dea) {
            this.dea = dea;
        }

        @Pure
        public double getMacd() {
            return this.macd;
        }

        public void setMacd(double macd) {
            this.macd = macd;
        }
    }
}

