package cool.taomu.box.stock;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@SuppressWarnings("all")
public class StockUtils {
  @Accessors
  public static class MacdData {
    private double dif;
    
    private double dea;
    
    private double macd;
    
    @Pure
    public double getDif() {
      return this.dif;
    }
    
    public void setDif(final double dif) {
      this.dif = dif;
    }
    
    @Pure
    public double getDea() {
      return this.dea;
    }
    
    public void setDea(final double dea) {
      this.dea = dea;
    }
    
    @Pure
    public double getMacd() {
      return this.macd;
    }
    
    public void setMacd(final double macd) {
      this.macd = macd;
    }
  }
  
  public static double sma(final List<Object> closePrice, final int periodsAverage) {
    double sum = 0;
    for (int i = (closePrice.size() - periodsAverage); (i < closePrice.size()); i++) {
      double _sum = sum;
      Object _get = closePrice.get(i);
      sum = (_sum + (((Double) _get)).doubleValue());
    }
    Double res = Double.valueOf(String.format("%.2f", Double.valueOf((sum / periodsAverage))));
    return (res).doubleValue();
  }
  
  public static double ema(final List<Object> closePrice, final int period) {
    Double k = Double.valueOf((2.0 / (period + 1.0)));
    Object _get = closePrice.get(0);
    Double ema = ((Double) _get);
    for (int i = 1; (i < closePrice.size()); i++) {
      Object _get_1 = closePrice.get(i);
      double _multiply = DoubleExtensions.operator_multiply(((Double) _get_1), k);
      double _plus = (_multiply + ((ema).doubleValue() * (1 - (k).doubleValue())));
      ema = Double.valueOf(_plus);
    }
    return (ema).doubleValue();
  }
  
  public static StockUtils.MacdData macd(final List<Object> closePrice, final int shortPeriod, final int longPeriod, final int midPeriod) {
    List<Object> diffList = new ArrayList<Object>();
    double shortEma = 0.0;
    double longEma = 0.0;
    double dif = 0.0;
    double dea = 0.0;
    for (int i = (closePrice.size() - 1); (i >= 0); i--) {
      {
        int _size = closePrice.size();
        int _minus = (_size - i);
        List<Object> sublist = closePrice.subList(0, _minus);
        shortEma = StockUtils.ema(sublist, shortPeriod);
        longEma = StockUtils.ema(sublist, longPeriod);
        dif = (shortEma - longEma);
        diffList.add(Double.valueOf(dif));
      }
    }
    dea = StockUtils.ema(diffList, midPeriod);
    dif = (Double.valueOf(String.format("%.2f", Double.valueOf(dif)))).doubleValue();
    dea = (Double.valueOf(String.format("%.2f", Double.valueOf(dea)))).doubleValue();
    StockUtils.MacdData data = new StockUtils.MacdData();
    data.dif = dif;
    data.dea = dea;
    data.macd = (Double.valueOf(String.format("%.2f", Double.valueOf(((dif - dea) * 2))))).doubleValue();
    return data;
  }
}
