/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.stock;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cool.taomu.box.stock.entity.SohuStockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.joda.time.LocalDate;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class StockHistory {
    public static List<Double> getData(String code) {
        try {
            String now = new LocalDate().toString("yyyyMMdd");
            String dt = new LocalDate().plusDays(-365).toString("yyyyMMdd");
            String url = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"https://q.stock.sohu.com/hisHq?code=cn_", code, "&start=", dt, "&end=", now, "&stat=1&order=D&period=d"})), (CharSequence)"");
            Connection con = Jsoup.connect((String)url).ignoreContentType(true);
            Document doc = con.get();
            String jsonStr = doc.body().text();
            Gson _gson = new Gson();
            List sse = (List)_gson.fromJson(jsonStr, (TypeToken)new TypeToken<List<SohuStockEntity>>(){});
            ArrayList closes = CollectionLiterals.newArrayList();
            Consumer<SohuStockEntity> _function = it -> {
                Consumer<List> _function_1 = it_1 -> closes.add(Double.valueOf((String)it_1.get(2)));
                IterableExtensions.filterNull(it.getHq()).forEach(_function_1);
            };
            sse.forEach(_function);
            return ListExtensions.reverse((List)closes);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void main(String[] args) {
        InputOutput.println(StockHistory.getData("002802"));
    }
}

