package cool.taomu.box.stock;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cool.taomu.box.stock.entity.SohuStockEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.joda.time.LocalDate;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@SuppressWarnings("all")
public class StockHistory {
  public static List<Double> getData(final String code) {
    try {
      String now = new LocalDate().toString("yyyyMMdd");
      String dt = new LocalDate().plusDays((-365)).toString("yyyyMMdd");
      String url = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("https://q.stock.sohu.com/hisHq?code=cn_", code, "&start=", dt, "&end=", now, "&stat=1&order=D&period=d")), "");
      Connection con = Jsoup.connect(url).ignoreContentType(true);
      Document doc = con.get();
      String jsonStr = doc.body().text();
      Gson _gson = new Gson();
      List<SohuStockEntity> sse = _gson.<List<SohuStockEntity>>fromJson(jsonStr, new TypeToken<List<SohuStockEntity>>() {
      });
      final List<Double> closes = CollectionLiterals.<Double>newArrayList();
      final Consumer<SohuStockEntity> _function = (SohuStockEntity it) -> {
        final Consumer<List<String>> _function_1 = (List<String> it_1) -> {
          closes.add(Double.valueOf(it_1.get(2)));
        };
        IterableExtensions.<List<String>>filterNull(it.getHq()).forEach(_function_1);
      };
      sse.forEach(_function);
      return ListExtensions.<Double>reverse(closes);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    InputOutput.<List<Double>>println(StockHistory.getData("002802"));
  }
}
