package cool.taomu.box.task.dataentity;

import java.io.Serializable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Accessors
@ToString
@SuppressWarnings("all")
public class DataStructureEntity implements Serializable {
  private String clientId = "ALL";
  
  private String senderId = "None";
  
  private String topicName = "#";
  
  private String callbackTopic = "None";
  
  private String method = "entry";
  
  private long timestamp;
  
  private byte[] payLoad = new byte[0];
  
  public DataStructureEntity() {
    DateTime utcDateTime = DateTime.now(DateTimeZone.UTC);
    this.timestamp = utcDateTime.getMillis();
  }
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public String getSenderId() {
    return this.senderId;
  }
  
  public void setSenderId(final String senderId) {
    this.senderId = senderId;
  }
  
  @Pure
  public String getTopicName() {
    return this.topicName;
  }
  
  public void setTopicName(final String topicName) {
    this.topicName = topicName;
  }
  
  @Pure
  public String getCallbackTopic() {
    return this.callbackTopic;
  }
  
  public void setCallbackTopic(final String callbackTopic) {
    this.callbackTopic = callbackTopic;
  }
  
  @Pure
  public String getMethod() {
    return this.method;
  }
  
  public void setMethod(final String method) {
    this.method = method;
  }
  
  @Pure
  public long getTimestamp() {
    return this.timestamp;
  }
  
  public void setTimestamp(final long timestamp) {
    this.timestamp = timestamp;
  }
  
  @Pure
  public byte[] getPayLoad() {
    return this.payLoad;
  }
  
  public void setPayLoad(final byte[] payLoad) {
    this.payLoad = payLoad;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("clientId", this.clientId);
    b.add("senderId", this.senderId);
    b.add("topicName", this.topicName);
    b.add("callbackTopic", this.callbackTopic);
    b.add("method", this.method);
    b.add("timestamp", this.timestamp);
    b.add("payLoad", this.payLoad);
    return b.toString();
  }
}
