package cool.taomu.box.thread.cluster;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.inter.IDataSource;
import cool.taomu.box.thread.cluster.entity.TaskEntity;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import redis.clients.jedis.Jedis;

@SuppressWarnings("all")
public class Runtime {
  private int coreSize;
  
  @Inject
  @Named("redis")
  private IDataSource ds;
  
  public void execute(final BlockingQueue<Runnable> workQueue) {
    TaomuRunsPolicy policy = new TaomuRunsPolicy(this.ds);
    ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.coreSize, this.coreSize, 60, TimeUnit.SECONDS, workQueue, policy);
    while (true) {
      try (Jedis jedis = this.ds.<Jedis>resource()) {
        String taskEntityStr = jedis.brpop(0, "globelQueue").get(0);
        TaskEntity taskEntity = SerializationUtils.<TaskEntity>deserialize(taskEntityStr.getBytes());
        TaomuRunnable taomuRunable = new TaomuRunnable(taskEntity);
        threadPool.execute(taomuRunable);
      }
    }
  }
  
  public static void main(final String[] args) {
  }
}
