/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 * http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.thread.cluster.entity;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public final class TaskEntity implements Serializable {
  public enum ScriptType {
    None,
    
    Groovy,
    
    JavaScript,
    
    Jython,
    
    JRuby,
    
    Bsh;
  }
  
  public enum DeplyType {
    None,
    
    Deply,
    
    Redeployment;
  }
  
  private String uuid;
  
  private String main_class;
  
  private String queue = "globalQueue";
  
  private TaskEntity.DeplyType deplyType = TaskEntity.DeplyType.None;
  
  private TaskEntity.ScriptType scriptType = TaskEntity.ScriptType.None;
  
  private String script;
  
  private String payload;
  
  public TaskEntity(final String queue) {
    this();
    this.queue = queue;
  }
  
  public TaskEntity() {
    this.uuid = UUID.randomUUID().toString();
  }
  
  public void setQueue(final String queue) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
  
  public byte[] getBytes() {
    return SerializationUtils.serialize(this);
  }
  
  @Pure
  public String getUuid() {
    return this.uuid;
  }
  
  public void setUuid(final String uuid) {
    this.uuid = uuid;
  }
  
  @Pure
  public String getMain_class() {
    return this.main_class;
  }
  
  public void setMain_class(final String main_class) {
    this.main_class = main_class;
  }
  
  @Pure
  public String getQueue() {
    return this.queue;
  }
  
  @Pure
  public TaskEntity.DeplyType getDeplyType() {
    return this.deplyType;
  }
  
  public void setDeplyType(final TaskEntity.DeplyType deplyType) {
    this.deplyType = deplyType;
  }
  
  @Pure
  public TaskEntity.ScriptType getScriptType() {
    return this.scriptType;
  }
  
  public void setScriptType(final TaskEntity.ScriptType scriptType) {
    this.scriptType = scriptType;
  }
  
  @Pure
  public String getScript() {
    return this.script;
  }
  
  public void setScript(final String script) {
    this.script = script;
  }
  
  @Pure
  public String getPayload() {
    return this.payload;
  }
  
  public void setPayload(final String payload) {
    this.payload = payload;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("uuid", this.uuid);
    b.add("main_class", this.main_class);
    b.add("queue", this.queue);
    b.add("deplyType", this.deplyType);
    b.add("scriptType", this.scriptType);
    b.add("script", this.script);
    b.add("payload", this.payload);
    return b.toString();
  }
}
