/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.thread.cluster;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cool.taomu.box.inter.IDataSource;
import cool.taomu.box.thread.cluster.TaomuRunnable;
import cool.taomu.box.thread.cluster.TaomuRunsPolicy;
import cool.taomu.box.thread.cluster.entity.TaskEntity;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SerializationUtils;
import redis.clients.jedis.Jedis;

public class Runtime {
    private int coreSize;
    @Inject
    @Named(value="redis")
    private IDataSource ds;

    public void execute(BlockingQueue<Runnable> workQueue) {
        TaomuRunsPolicy policy = new TaomuRunsPolicy(this.ds);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.coreSize, this.coreSize, 60L, TimeUnit.SECONDS, workQueue, policy);
        while (true) {
            Jedis jedis = (Jedis)this.ds.resource();
            try {
                String taskEntityStr = (String)jedis.brpop(0, "globelQueue").get(0);
                TaskEntity taskEntity = (TaskEntity)SerializationUtils.deserialize((byte[])taskEntityStr.getBytes());
                TaomuRunnable taomuRunable = new TaomuRunnable(taskEntity);
                threadPool.execute(taomuRunable);
                continue;
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
    }
}

