/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.box.thread.cluster;

import cool.taomu.box.inter.IDataSource;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

@SuppressWarnings("all")
public class TaomuRunsPolicy extends ThreadPoolExecutor.CallerRunsPolicy {
  private static final Logger LOG = LoggerFactory.getLogger(TaomuRunsPolicy.class);
  
  private IDataSource ds;
  
  public TaomuRunsPolicy(final IDataSource ds) {
    this.ds = ds;
  }
  
  protected void _rejectedExecution(final TaomuRunnable r, final ThreadPoolExecutor executor) {
    TaomuRunsPolicy.LOG.info("TaomuTask当前被拒绝任务为:{}", r.getTask().getMain_class());
    try (Jedis jedis = this.ds.<Jedis>resource()) {
      byte[] _bytes = r.getTask().getBytes();
      String _string = new String(_bytes, "UTF-8");
      jedis.lpush(r.getTask().getQueue(), _string);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        TaomuRunsPolicy.LOG.info("网络异常：", e);
        super.rejectedExecution(r, executor);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  protected void _rejectedExecution(final Runnable r, final ThreadPoolExecutor executor) {
    TaomuRunsPolicy.LOG.info("当前被拒绝任务为:{}", r.toString());
    super.rejectedExecution(r, executor);
  }
  
  public void rejectedExecution(final Runnable r, final ThreadPoolExecutor executor) {
    if (r instanceof TaomuRunnable) {
      _rejectedExecution((TaomuRunnable)r, executor);
      return;
    } else if (r != null) {
      _rejectedExecution(r, executor);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(r, executor).toString());
    }
  }
}
