package cool.taomu.box.tomcat.config;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cool.taomu.box.guice.ann.Binder;
import cool.taomu.box.tomcat.ITomcatFilter;
import javax.servlet.Servlet;

@Binder(bind = Servlet.class, to = TomcatDefaultHttpServletProvider.class, provider = true)
@Binder(bind = ITomcatFilter.class, to = TomcatDefaultFilterProvider.class, provider = true)
@SuppressWarnings("all")
public class TomcatDefaultModule extends AbstractModule {
  @Override
  protected void configure() {
    this.binder().<Integer>bind(int.class).annotatedWith(Names.named("port")).toInstance(Integer.valueOf(8080));
  }
}
