package cool.taomu.box.tomcat.config;

import com.google.inject.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TomcatDefaultHttpServletProvider implements Provider<Servlet> {
  private static final Logger LOG = LoggerFactory.getLogger(TomcatDefaultHttpServletProvider.class);
  
  @Override
  public Servlet get() {
    TomcatDefaultHttpServletProvider.LOG.info("加载 http servlet");
    return new HttpServlet() {
      @Override
      public void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        String name = request.getRequestURI();
        TomcatDefaultHttpServletProvider.LOG.info("请求链接:{}", name);
        try (PrintWriter w = new Function0<PrintWriter>() {
          @Override
          public PrintWriter apply() {
            try {
              return response.getWriter();
            } catch (Throwable _e) {
              throw Exceptions.sneakyThrow(_e);
            }
          }
        }.apply()) {
          w.write("Hello Taomu box");
          w.flush();
        }
      }
    };
  }
}
