/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.box.tomcat;

import com.google.inject.name.Named;
import cool.taomu.box.tomcat.ITomcatFilter;
import cool.taomu.box.tomcat.ITomcatServer;
import java.io.File;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatServer
implements ITomcatServer {
    private final Logger LOG = LoggerFactory.getLogger(TomcatServer.class);
    @Inject
    private Servlet servlet;
    @Inject
    private ITomcatFilter ifilter;
    @Inject
    @Named(value="port")
    private int port;
    @Inject
    @Named(value="host")
    private String host;

    @Override
    public void start() {
        try {
            String _property = System.getProperty("java.io.tmpdir");
            File base = new File(_property);
            Tomcat tomcat = new Tomcat();
            Runtime _runtime = Runtime.getRuntime();
            Runnable _function = () -> {
                try {
                    tomcat.destroy();
                }
                catch (Throwable _t) {
                    if (_t instanceof LifecycleException) {
                        LifecycleException e = (LifecycleException)_t;
                        e.printStackTrace();
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            Thread _thread = new Thread(_function);
            _runtime.addShutdownHook(_thread);
            tomcat.setHostname(this.host);
            tomcat.setPort(this.port);
            tomcat.getConnector();
            Context ctx = tomcat.addContext("/", base.getAbsolutePath());
            this.addFilter(ctx);
            Wrapper wrapper = Tomcat.addServlet((Context)ctx, (String)"base", (Servlet)this.servlet);
            tomcat.start();
            wrapper.setLoadOnStartup(1);
            wrapper.addMapping("/");
            tomcat.getServer().await();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void addFilter(Context ctx) {
        if (this.ifilter != null) {
            Consumer<FilterDef> _function = it -> {
                this.LOG.info("Filter def :{}", (Object)it.getFilterName());
                ctx.addFilterDef(it);
            };
            IterableExtensions.filterNull(this.ifilter.filterDefs()).forEach(_function);
            Consumer<FilterMap> _function_1 = it -> {
                this.LOG.info("Filter map :{}", (Object)it.getFilterName());
                ctx.addFilterMap(it);
            };
            IterableExtensions.filterNull(this.ifilter.filterMaps()).forEach(_function_1);
            Consumer<Class> _function_2 = it -> {
                this.LOG.info("listener :{}", (Object)it.getName());
                ctx.addApplicationListener(it.getName());
            };
            IterableExtensions.filterNull(this.ifilter.listeners()).forEach(_function_2);
        }
    }
}

