package cool.taomu.box.tomcat;

import com.google.inject.name.Named;
import java.io.File;
import java.util.EventListener;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TomcatServer implements ITomcatServer {
  private final Logger LOG = LoggerFactory.getLogger(TomcatServer.class);
  
  @Inject
  private Servlet servlet;
  
  @Inject
  private ITomcatFilter ifilter;
  
  @Inject
  @Named("port")
  private int port;
  
  @Inject
  @Named("host")
  private String host;
  
  @Override
  public void start() {
    try {
      String _property = System.getProperty("java.io.tmpdir");
      File base = new File(_property);
      final Tomcat tomcat = new Tomcat();
      Runtime _runtime = Runtime.getRuntime();
      final Runnable _function = () -> {
        try {
          tomcat.destroy();
        } catch (final Throwable _t) {
          if (_t instanceof LifecycleException) {
            final LifecycleException e = (LifecycleException)_t;
            e.printStackTrace();
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
      };
      Thread _thread = new Thread(_function);
      _runtime.addShutdownHook(_thread);
      tomcat.setHostname(this.host);
      tomcat.setPort(this.port);
      tomcat.getConnector();
      final Context ctx = tomcat.addContext("/", base.getAbsolutePath());
      this.addFilter(ctx);
      Wrapper wrapper = Tomcat.addServlet(ctx, "base", this.servlet);
      tomcat.start();
      wrapper.setLoadOnStartup(1);
      wrapper.addMapping("/");
      tomcat.getServer().await();
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected void addFilter(final Context ctx) {
    if ((this.ifilter != null)) {
      final Consumer<FilterDef> _function = (FilterDef it) -> {
        this.LOG.info("Filter def :{}", it.getFilterName());
        ctx.addFilterDef(it);
      };
      IterableExtensions.<FilterDef>filterNull(this.ifilter.filterDefs()).forEach(_function);
      final Consumer<FilterMap> _function_1 = (FilterMap it) -> {
        this.LOG.info("Filter map :{}", it.getFilterName());
        ctx.addFilterMap(it);
      };
      IterableExtensions.<FilterMap>filterNull(this.ifilter.filterMaps()).forEach(_function_1);
      final Consumer<Class<? extends EventListener>> _function_2 = (Class<? extends EventListener> it) -> {
        this.LOG.info("listener :{}", it.getName());
        ctx.addApplicationListener(it.getName());
      };
      IterableExtensions.<Class<? extends EventListener>>filterNull(this.ifilter.listeners()).forEach(_function_2);
    }
  }
}
