package cool.taomu.box.tomcat.config;

import com.google.inject.Provider;
import cool.taomu.box.tomcat.ITomcatFilter;
import java.util.EventListener;
import java.util.List;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TomcatDefaultFilterProvider implements Provider<ITomcatFilter> {
  private static final Logger LOG = LoggerFactory.getLogger(TomcatDefaultFilterProvider.class);
  
  @Override
  public ITomcatFilter get() {
    TomcatDefaultFilterProvider.LOG.info("加载tomcat filter");
    return new ITomcatFilter() {
      @Override
      public List<FilterDef> filterDefs() {
        return null;
      }
      
      @Override
      public List<FilterMap> filterMaps() {
        return null;
      }
      
      @Override
      public List<Class<? extends EventListener>> listeners() {
        return null;
      }
    };
  }
}
