/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.client.mqtt;

import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MqttCallback
implements org.eclipse.paho.client.mqttv3.MqttCallback {
    static final Logger LOG = LoggerFactory.getLogger(MqttCallback.class);
    private MqttClient client;
    private MqttConnectOptions options;

    public void setClient(MqttClient client) {
        this.client = client;
    }

    public void setOptions(MqttConnectOptions options) {
        this.options = options;
    }

    public void connectionLost(Throwable cause) {
        LOG.debug("Client connectionLost: {}", (Object)cause.getMessage());
        try {
            this.client.reconnect();
            while (true) {
                try {
                    do {
                        TimeUnit.SECONDS.sleep(1L);
                        this.client.connect(this.options);
                    } while (!this.client.isConnected());
                }
                catch (InterruptedException | MqttException e) {
                    LOG.info("clientId : {} \u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5", (Object)this.client.getClientId(), (Object)e);
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
        catch (MqttException e1) {
            LOG.info("MqttExecption : ", (Throwable)e1);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        for (String i : token.getTopics()) {
            LOG.debug("Client deliveryComplete : {}", (Object)i);
        }
    }

    public abstract void messageArrived(String var1, MqttMessage var2) throws Exception;
}

