/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.client.mqtt;

import cool.taomu.framework.client.mqtt.SenderEntity;
import cool.taomu.framework.crypto.Base64;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private final Logger LOG = LoggerFactory.getLogger(Sender.class);

    public void send(SenderEntity sender) {
        this.send(sender, false);
    }

    public static void sendOut(SenderEntity sender) {
        new Sender().send(sender);
    }

    public static void sendOut(SenderEntity sender, boolean isSsl) {
        new Sender().send(sender, isSsl);
    }

    public void send(SenderEntity sender, boolean isSsl) {
        String _string = sender.toString();
        String _plus = "mqtt sender info:" + _string;
        this.LOG.info(_plus);
        try (MemoryPersistence memoryPersistence = new MemoryPersistence();){
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setCleanSession(true);
            mqttConnectOptions.setUserName(sender.getUsername());
            mqttConnectOptions.setPassword(sender.getPassword().toCharArray());
            mqttConnectOptions.setConnectionTimeout(sender.getTimeout());
            mqttConnectOptions.setKeepAliveInterval(20);
            String _xifexpression = null;
            _xifexpression = isSsl ? "ssl" : "tcp";
            String _format = String.format("%s://%s:%d", _xifexpression, sender.getIp(), sender.getPort());
            String _clientId = sender.getClientId();
            MqttClient mqttClient = new MqttClient(_format, _clientId, (MqttClientPersistence)memoryPersistence);
            mqttClient.connect(mqttConnectOptions);
            byte[] _bytes = sender.getMessage().getBytes();
            byte[] _encode = new Base64(_bytes).encode();
            MqttMessage mqttMessage = new MqttMessage(_encode);
            mqttMessage.setQos(sender.getQos().value());
            mqttMessage.setRetained(sender.isRetain());
            mqttClient.publish(sender.getTopic(), mqttMessage);
            this.LOG.debug("clientId: {} \u53d1\u9001\u6210\u529f", (Object)sender.getClientId());
            mqttClient.disconnect();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                ex.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

