/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.client.mqtt;

import com.google.gson.Gson;
import cool.taomu.framework.client.mqtt.MqttCallback;
import cool.taomu.framework.client.mqtt.MqttClient;
import cool.taomu.framework.client.mqtt.annotation.Topic;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.ISpringPlugin;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscriber {
    private final Logger LOG = LoggerFactory.getLogger(Subscriber.class);
    private String username;
    private String password;
    private String ip = "0.0.0.0";
    private int port = 1883;

    public Subscriber(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Subscriber(String ip, int port, String username, String password) {
        this.username = username;
        this.password = password;
        this.ip = ip;
        this.port = port;
    }

    public void subscriber(Class<? extends MqttCallback> ... callbacks) {
        this.subscriber((ISpringPlugin)null, callbacks);
    }

    public void subscriber(ISpringPlugin spring, Class<? extends MqttCallback> ... callbacks) {
        Consumer<Class> _function = it -> {
            Runnable _function_1 = () -> {
                try {
                    Topic topic = it.getAnnotation(Topic.class);
                    if (topic != null) {
                        boolean _not;
                        String _json = new Gson().toJson((Object)topic.value());
                        String _plus = "Topic : " + _json;
                        this.LOG.info(_plus);
                        final MemoryPersistence memoryPersistence = new MemoryPersistence();
                        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                        mqttConnectOptions.setCleanSession(topic.cleanSession());
                        mqttConnectOptions.setUserName(this.username);
                        mqttConnectOptions.setPassword(this.password.toCharArray());
                        mqttConnectOptions.setConnectionTimeout(topic.timeout());
                        mqttConnectOptions.setKeepAliveInterval(topic.keepAlive());
                        String _xifexpression = null;
                        boolean _isSsl = topic.isSsl();
                        _xifexpression = _isSsl ? "ssl" : "tcp";
                        String broker = String.format("%s://%s:%d", _xifexpression, this.ip, this.port);
                        String uuid = UUID.randomUUID().toString();
                        boolean _equals = topic.clientId().equals("uuid");
                        boolean bl = _not = !_equals;
                        if (_not) {
                            uuid = topic.clientId();
                        }
                        final MqttClient mqttClient = new MqttClient(broker, uuid, (MqttClientPersistence)memoryPersistence);
                        mqttClient.setCallback(mqttConnectOptions, (Class<? extends MqttCallback>)it, spring);
                        mqttClient.connect(mqttConnectOptions);
                        ArrayList<Integer> qoss = new ArrayList<Integer>();
                        Functions.Function1 _function_2 = it_1 -> it_1.value();
                        qoss.addAll(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)topic.qos())), (Functions.Function1)_function_2));
                        for (int i = 0; qoss.size() < ((List)Conversions.doWrapArray((Object)topic.value())).size() && i < ((List)Conversions.doWrapArray((Object)topic.value())).size() - qoss.size(); ++i) {
                            qoss.add(MqttQoS.AT_MOST_ONCE.value());
                        }
                        ArrayList<Integer> _converted_qoss = qoss;
                        mqttClient.subscribe(topic.value(), (int[])Conversions.unwrapArray(_converted_qoss, Integer.TYPE));
                        Runtime _runtime = Runtime.getRuntime();
                        _runtime.addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                try {
                                    mqttClient.disconnect();
                                    memoryPersistence.close();
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        });
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            CommonUtils.exec((Runnable)_function_1);
        };
        IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(callbacks))).forEach(_function);
        Runtime _runtime = Runtime.getRuntime();
        _runtime.addShutdownHook(new Thread(){

            @Override
            public void run() {
                CommonUtils.shutdown();
            }
        });
    }
}

