/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.framework.client.mqtt;

import cool.taomu.framework.configure.ConfigureManage;
import cool.taomu.framework.configure.entity.ConfigureEntity;
import cool.taomu.framework.crypto.ICrypto;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
public class SenderEntity
implements Serializable {
    private final ConfigureEntity config = ConfigureManage.loadConfig();
    private String clientId;
    private String ip = this.config.getMqtt().getHostname();
    private MqttQoS qos = MqttQoS.AT_LEAST_ONCE;
    private String topic;
    private String username = this.config.getMqtt().getUsername().trim();
    private String password = this.config.getMqtt().getPassword().trim();
    private String message = "None";
    private boolean retain = false;
    private int timeout = 10;
    private int port = this.config.getMqtt().getPort();

    public SenderEntity() {
        this.clientId = UUID.randomUUID().toString();
    }

    public SenderEntity(String topic) {
        this.clientId = UUID.randomUUID().toString();
        this.topic = topic;
    }

    public SenderEntity(String clientId, String topic) {
        this.clientId = clientId;
        this.topic = topic;
    }

    public SenderEntity topic(String topic) {
        this.topic = topic;
        return this;
    }

    public SenderEntity clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public SenderEntity message(String message) {
        return this.message(message, null);
    }

    public SenderEntity message(String message, ICrypto crypto) {
        try {
            if (crypto != null) {
                String _string;
                byte[] _encode = crypto.setData(message.getBytes()).encode();
                this.message = _string = new String(_encode, "UTF-8");
            } else {
                this.message = message;
            }
            return this;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public SenderEntity qos(MqttQoS qos) {
        this.qos = qos;
        return this;
    }

    public SenderEntity retain(boolean retain) {
        this.retain = retain;
        return this;
    }

    public SenderEntity ip(String broker) {
        this.ip = this.ip;
        return this;
    }

    public SenderEntity broker(String ip, int port) {
        this.ip = ip;
        this.port = port;
        return this;
    }

    public SenderEntity port(int port) {
        this.port = port;
        return this;
    }

    public SenderEntity username(String username) {
        this.username = username;
        return this;
    }

    public SenderEntity password(String pwd) {
        this.password = pwd;
        return this;
    }

    public SenderEntity clone() {
        return (SenderEntity)SerializationUtils.clone((Serializable)this);
    }

    @Pure
    public ConfigureEntity getConfig() {
        return this.config;
    }

    @Pure
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Pure
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Pure
    public MqttQoS getQos() {
        return this.qos;
    }

    public void setQos(MqttQoS qos) {
        this.qos = qos;
    }

    @Pure
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Pure
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Pure
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Pure
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Pure
    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    @Pure
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Pure
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("config", (Object)this.config);
        b.add("clientId", (Object)this.clientId);
        b.add("ip", (Object)this.ip);
        b.add("qos", (Object)this.qos);
        b.add("topic", (Object)this.topic);
        b.add("username", (Object)this.username);
        b.add("password", (Object)this.password);
        b.add("message", (Object)this.message);
        b.add("retain", (Object)this.retain);
        b.add("timeout", (Object)this.timeout);
        b.add("port", (Object)this.port);
        return b.toString();
    }
}

