/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker;

import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.ServiceLoader;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@SuppressWarnings("all")
public class MQTTHandler extends ChannelInboundHandlerAdapter {
  private final Logger LOG = LoggerFactory.getLogger(MQTTHandler.class);
  
  @Override
  public void channelRead(final ChannelHandlerContext ctx, final Object obj) {
    final MqttMessage mqttMessage = ((MqttMessage) obj);
    if (((mqttMessage != null) && mqttMessage.decoderResult().isSuccess())) {
      MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
      final String typeName = messageType.name();
      this.LOG.debug("收到请求类型：{}", typeName);
      final IRequest msg = ServiceLoader.<IRequest>load(IRequest.class).get(typeName);
      final Runnable _function = () -> {
        final List<MqttMessage> msgs = msg.request(ctx, mqttMessage);
        if ((msgs != null)) {
          final Consumer<MqttMessage> _function_1 = (MqttMessage r) -> {
            Assert.assertNotNull(r);
            ctx.writeAndFlush(r);
          };
          IterableExtensions.<MqttMessage>filterNull(msgs).forEach(_function_1);
        }
      };
      CommonUtils.exec(_function);
    } else {
      ctx.close();
    }
  }
}
