/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class ConnackEntity {
  private MqttConnectReturnCode code;
  
  private boolean sessionPresent;
  
  public ConnackEntity(final MqttConnectReturnCode code, final boolean sessionPresent) {
    this.code = code;
    this.sessionPresent = sessionPresent;
  }
  
  @Pure
  public MqttConnectReturnCode getCode() {
    return this.code;
  }
  
  public void setCode(final MqttConnectReturnCode code) {
    this.code = code;
  }
  
  @Pure
  public boolean isSessionPresent() {
    return this.sessionPresent;
  }
  
  public void setSessionPresent(final boolean sessionPresent) {
    this.sessionPresent = sessionPresent;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("code", this.code);
    b.add("sessionPresent", this.sessionPresent);
    return b.toString();
  }
}
