/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class MessageEntity implements Serializable {
  private transient Channel senderChannel;
  
  private String senderId;
  
  private int msgId;
  
  private MqttQoS qos;
  
  private String topic;
  
  private boolean dup;
  
  private boolean retain = false;
  
  private Integer type;
  
  private byte[] payload;
  
  public byte[] setPayload(final ByteBuf byteBuf) {
    byte[] _xblockexpression = null;
    {
      ByteBuffer bb = ByteBuffer.allocate(byteBuf.readableBytes());
      byteBuf.readBytes(bb);
      _xblockexpression = this.payload = bb.array();
    }
    return _xblockexpression;
  }
  
  @Pure
  public Channel getSenderChannel() {
    return this.senderChannel;
  }
  
  public void setSenderChannel(final Channel senderChannel) {
    this.senderChannel = senderChannel;
  }
  
  @Pure
  public String getSenderId() {
    return this.senderId;
  }
  
  public void setSenderId(final String senderId) {
    this.senderId = senderId;
  }
  
  @Pure
  public int getMsgId() {
    return this.msgId;
  }
  
  public void setMsgId(final int msgId) {
    this.msgId = msgId;
  }
  
  @Pure
  public MqttQoS getQos() {
    return this.qos;
  }
  
  public void setQos(final MqttQoS qos) {
    this.qos = qos;
  }
  
  @Pure
  public String getTopic() {
    return this.topic;
  }
  
  public void setTopic(final String topic) {
    this.topic = topic;
  }
  
  @Pure
  public boolean isDup() {
    return this.dup;
  }
  
  public void setDup(final boolean dup) {
    this.dup = dup;
  }
  
  @Pure
  public boolean isRetain() {
    return this.retain;
  }
  
  public void setRetain(final boolean retain) {
    this.retain = retain;
  }
  
  @Pure
  public Integer getType() {
    return this.type;
  }
  
  public void setType(final Integer type) {
    this.type = type;
  }
  
  @Pure
  public byte[] getPayload() {
    return this.payload;
  }
  
  public void setPayload(final byte[] payload) {
    this.payload = payload;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("senderId", this.senderId);
    b.add("msgId", this.msgId);
    b.add("qos", this.qos);
    b.add("topic", this.topic);
    b.add("dup", this.dup);
    b.add("retain", this.retain);
    b.add("type", this.type);
    b.add("payload", this.payload);
    return b.toString();
  }
}
