/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class PubRecEntity {
  private Integer messageId;
  
  private Boolean isDup = Boolean.valueOf(false);
  
  public PubRecEntity(final Integer messageId) {
    this.messageId = messageId;
  }
  
  @Pure
  public Integer getMessageId() {
    return this.messageId;
  }
  
  public void setMessageId(final Integer messageId) {
    this.messageId = messageId;
  }
  
  @Pure
  public Boolean getIsDup() {
    return this.isDup;
  }
  
  public void setIsDup(final Boolean isDup) {
    this.isDup = isDup;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("messageId", this.messageId);
    b.add("isDup", this.isDup);
    return b.toString();
  }
}
