/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.entity;

import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class WillEntity implements Serializable {
  private String clientId;
  
  private boolean retain;
  
  private MqttQoS qos;
  
  private String topic;
  
  private boolean will;
  
  private byte[] payload;
  
  @Pure
  public String getClientId() {
    return this.clientId;
  }
  
  public void setClientId(final String clientId) {
    this.clientId = clientId;
  }
  
  @Pure
  public boolean isRetain() {
    return this.retain;
  }
  
  public void setRetain(final boolean retain) {
    this.retain = retain;
  }
  
  @Pure
  public MqttQoS getQos() {
    return this.qos;
  }
  
  public void setQos(final MqttQoS qos) {
    this.qos = qos;
  }
  
  @Pure
  public String getTopic() {
    return this.topic;
  }
  
  public void setTopic(final String topic) {
    this.topic = topic;
  }
  
  @Pure
  public boolean isWill() {
    return this.will;
  }
  
  public void setWill(final boolean will) {
    this.will = will;
  }
  
  @Pure
  public byte[] getPayload() {
    return this.payload;
  }
  
  public void setPayload(final byte[] payload) {
    this.payload = payload;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("clientId", this.clientId);
    b.add("retain", this.retain);
    b.add("qos", this.qos);
    b.add("topic", this.topic);
    b.add("will", this.will);
    b.add("payload", this.payload);
    return b.toString();
  }
}
