/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import cool.taomu.framework.cache.KeyValueCache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PublishEntity;
import cool.taomu.framework.service.mqtt.broker.entity.TopicEntity;
import cool.taomu.framework.service.mqtt.broker.inter.IPublishObserver;
import cool.taomu.framework.service.mqtt.broker.inter.IResponse;
import cool.taomu.framework.service.utils.CommonUtils;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
@SuppressWarnings("all")
public class Publish implements IPublishObserver {
  private final Logger LOG = LoggerFactory.getLogger(Publish.class);
  
  private KeyValueCache cache = KeyValueCache.getInstance();
  
  private TopicEntity topic;
  
  private IResponse<PublishEntity> reponse;
  
  private static AtomicInteger count = new AtomicInteger(0);
  
  private int number = 0;
  
  public Publish(final TopicEntity topic, final IResponse<PublishEntity> reponse) {
    Publish.count.incrementAndGet();
    this.number = Publish.count.intValue();
    this.topic = topic;
    this.reponse = reponse;
  }
  
  @Override
  public void update(final List<MessageEntity> messages, final IPublishObserver.Type type) {
    this.publishMessage(messages, type);
  }
  
  private void publishMessage(final List<MessageEntity> messages, final IPublishObserver.Type type) {
    try {
      final Consumer<MessageEntity> _function = (MessageEntity msg) -> {
        Perl5Util p5 = new Perl5Util();
        String subTopicName = this.topic.getName().replace("/+", "/[a-zA-Z]?[a-zA-Z0-9]+").replace("/#", 
          "/[a-zA-Z]?([a-zA-Z0-9/]*)").replace("/", "\\/");
        this.LOG.info("订阅者id : {},  Topic : {}", this.topic.getClientId(), subTopicName);
        this.LOG.info("发送者id : {},  Topic : {}", msg.getSenderId(), msg.getTopic());
        boolean _match = p5.match((("/" + subTopicName) + "/"), msg.getTopic());
        if (_match) {
          this.LOG.info("匹配到订阅 ： {}", subTopicName);
          int qos = msg.getQos().value();
          int minQos = CommonUtils.getQos(qos, this.topic.getQos());
          if ((minQos == 2)) {
            MessageEntity cloneMsg = SerializationUtils.<MessageEntity>clone(msg);
            cloneMsg.setSenderChannel(msg.getSenderChannel());
            this.cache.store(CommonUtils.qos2Message(this.topic.getClientId()), cloneMsg);
          }
          Serializable _get = this.cache.get(CommonUtils.session(this.topic.getClientId()));
          ClientSessionEntity clientSession = ((ClientSessionEntity) _get);
          Assert.assertNotNull(clientSession);
          Assert.assertNotNull(this.topic);
          Assert.assertNotNull(this.topic.getName());
          Assert.assertNotNull(msg);
          byte[] _payload = msg.getPayload();
          String _string = new String(_payload);
          this.LOG.info("订阅者id : {},  Topic : {}, 发送 ： {}", this.topic.getClientId(), subTopicName, _string);
          MqttQoS _valueOf = MqttQoS.valueOf(minQos);
          String _name = this.topic.getName();
          int _generateMessageId = clientSession.generateMessageId();
          byte[] _payload_1 = msg.getPayload();
          PublishEntity entity = new PublishEntity(_valueOf, _name, 
            ((Integer) Integer.valueOf(_generateMessageId)), _payload_1, Boolean.valueOf(false));
          clientSession.getCtx().writeAndFlush(this.reponse.response(entity));
        }
      };
      IterableExtensions.<MessageEntity>filterNull(messages).forEach(_function);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception ex = (Exception)_t;
        this.LOG.debug("publishMessage 方法出现错误 : ", ex);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Pure
  public Logger getLOG() {
    return this.LOG;
  }
  
  @Pure
  public KeyValueCache getCache() {
    return this.cache;
  }
  
  public void setCache(final KeyValueCache cache) {
    this.cache = cache;
  }
  
  @Pure
  public TopicEntity getTopic() {
    return this.topic;
  }
  
  public void setTopic(final TopicEntity topic) {
    this.topic = topic;
  }
  
  @Pure
  public IResponse<PublishEntity> getReponse() {
    return this.reponse;
  }
  
  public void setReponse(final IResponse<PublishEntity> reponse) {
    this.reponse = reponse;
  }
  
  @Pure
  public int getNumber() {
    return this.number;
  }
  
  public void setNumber(final int number) {
    this.number = number;
  }
}
