/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl;

import com.google.common.collect.ArrayListMultimap;
import cool.taomu.framework.cache.KeyValueCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.inter.IPublishObserver;
import cool.taomu.framework.service.utils.CommonUtils;
import java.io.Serializable;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public final class PublishObservable {
  private Logger LOG = LoggerFactory.getLogger(PublishObservable.class);
  
  private static final ArrayListMultimap<String, IPublishObserver> observers = ArrayListMultimap.<String, IPublishObserver>create();
  
  private static final PublishObservable instance = new PublishObservable();
  
  private KeyValueCache cache = KeyValueCache.getInstance();
  
  private PublishObservable() {
  }
  
  public static synchronized PublishObservable getInstance() {
    return PublishObservable.instance;
  }
  
  public synchronized void register(final String key, final IPublishObserver arg) {
    this.LOG.info(("register :" + key));
    PublishObservable.observers.put(key, arg);
  }
  
  public synchronized void unregister(final String key) {
    this.LOG.info(("unregister :" + key));
    PublishObservable.observers.removeAll(key);
    int _size = PublishObservable.observers.size();
    String _plus = ("unregister :" + Integer.valueOf(_size));
    this.LOG.info(_plus);
  }
  
  public void start(final String id, final IPublishObserver.Type type) {
    synchronized (PublishObservable.observers) {
      this.LOG.info("observers number : {}", Integer.valueOf(PublishObservable.observers.size()));
      final Vector<MessageEntity> messages = new Vector<MessageEntity>();
      boolean _equals = type.equals(IPublishObserver.Type.RETAIN);
      if (_equals) {
        Serializable _get = this.cache.get(CommonUtils.retain("*"));
        Set<MessageEntity> rateins = ((Set<MessageEntity>) _get);
        if ((rateins != null)) {
          this.LOG.info("rateins 消息数 : {}", Integer.valueOf(rateins.size()));
          messages.addAll(rateins);
        }
      }
      boolean _equals_1 = type.equals(IPublishObserver.Type.MESSAGE);
      if (_equals_1) {
        Serializable _get_1 = this.cache.get(id);
        messages.add(((MessageEntity) _get_1));
      }
      final BiConsumer<String, IPublishObserver> _function = (String k, IPublishObserver v) -> {
        final Runnable _function_1 = () -> {
          v.update(SerializationUtils.<Vector<MessageEntity>>clone(messages), type);
        };
        CommonUtils.exec(_function_1);
      };
      PublishObservable.observers.forEach(_function);
    }
  }
}
