/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.KeyValueCache;
import cool.taomu.framework.service.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.framework.service.mqtt.broker.impl.PublishObservable;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * DISCONNECT 	|	14 	|	两个方向都允许	|	断开连接通知
 */
@Alias(value = "DISCONNECT")
@SuppressWarnings("all")
public class DisconnectRequest implements IRequest {
  private final Logger LOG = LoggerFactory.getLogger(DisconnectRequest.class);
  
  private KeyValueCache cache = KeyValueCache.getInstance();
  
  @Override
  public List<MqttMessage> request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    this.LOG.info("执行了MQTT Disconnect 命令");
    String clientId = CommonUtils.getClientId(ctx.channel());
    Serializable _get = this.cache.get(CommonUtils.session(clientId));
    ClientSessionEntity clientSession = ((ClientSessionEntity) _get);
    boolean _isCleanStatus = clientSession.isCleanStatus();
    if (_isCleanStatus) {
      this.cache.remove(CommonUtils.session(clientId));
    }
    PublishObservable.getInstance().unregister(clientId);
    ctx.close();
    return null;
  }
}
