/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.service.mqtt.broker.impl.response.PingRespResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PINGREQ  V	|	12 	|	客户端到服务端 	|	心跳请求
 */
@Alias(value = "PINGREQ")
@SuppressWarnings("all")
public class PingEqRequest implements IRequest {
  private final Logger LOG = LoggerFactory.getLogger(PingEqRequest.class);
  
  @Override
  public List<MqttMessage> request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = CommonUtils.getClientId(ctx.channel());
    this.LOG.debug(("执行了MQTT PingEq 命令 : " + clientId));
    MqttMessage _response = new PingRespResponse().response(null);
    return Collections.<MqttMessage>unmodifiableList(CollectionLiterals.<MqttMessage>newArrayList(_response));
  }
}
