/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.cache.SetCache;
import cool.taomu.framework.service.mqtt.broker.entity.MessageEntity;
import cool.taomu.framework.service.mqtt.broker.entity.PubRelEntity;
import cool.taomu.framework.service.mqtt.broker.impl.response.PubRelResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * PUBREL |	6 	|	两个方向都允许 	|	发布释放(保证交付第二步)
 */
@Alias(value = "PUBREL")
@SuppressWarnings("all")
public class PubRelRequest implements IRequest {
  private final Logger LOG = LoggerFactory.getLogger(PubRelRequest.class);
  
  private SetCache<MessageEntity> cache = SetCache.<MessageEntity>getInstance();
  
  @Override
  public List<MqttMessage> request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = CommonUtils.getClientId(ctx.channel());
    this.LOG.info(("执行了MQTT PubRel 命令 : " + clientId));
    Object _variableHeader = mqttMessage.variableHeader();
    MqttMessageIdVariableHeader idVariableHeader = ((MqttMessageIdVariableHeader) _variableHeader);
    int msgId = idVariableHeader.messageId();
    Set<MessageEntity> qos2 = this.cache.get(CommonUtils.qos2Message(clientId));
    for (final MessageEntity q : qos2) {
      {
        MessageEntity msg = ((MessageEntity) q);
        PubRelResponse _pubRelResponse = new PubRelResponse();
        PubRelEntity _pubRelEntity = new PubRelEntity(Integer.valueOf(msgId));
        MqttMessage entity = _pubRelResponse.response(_pubRelEntity);
        msg.getSenderChannel().writeAndFlush(entity);
        this.cache.remove(CommonUtils.qos2Message(clientId), msg);
        msg.setSenderChannel(ctx.channel());
        String senderId = msg.getSenderId();
        msg.setSenderId(clientId);
        this.cache.add(CommonUtils.qos2Message(senderId), msg);
      }
    }
    return null;
  }
}
