/**
 * Copyright (c) 2022 murenchao
 * taomu framework is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.framework.service.mqtt.broker.impl.request;

import cool.taomu.framework.service.mqtt.broker.entity.SubAckEntity;
import cool.taomu.framework.service.mqtt.broker.entity.TopicEntity;
import cool.taomu.framework.service.mqtt.broker.impl.Publish;
import cool.taomu.framework.service.mqtt.broker.impl.PublishObservable;
import cool.taomu.framework.service.mqtt.broker.impl.response.PublishResponse;
import cool.taomu.framework.service.mqtt.broker.impl.response.SubAckResponse;
import cool.taomu.framework.service.mqtt.broker.inter.IPublishObserver;
import cool.taomu.framework.service.mqtt.broker.inter.IRequest;
import cool.taomu.framework.service.utils.CommonUtils;
import cool.taomu.framework.utils.spi.Alias;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * SUBSCRIBE V   |   8   |   客户端到服务端     |   客户端订阅请求
 */
@Alias(value = "SUBSCRIBE")
@SuppressWarnings("all")
public class SubscribeRequest implements IRequest {
  private final Logger LOG = LoggerFactory.getLogger(ConnectRequest.class);
  
  @Override
  public List<MqttMessage> request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    try {
      String clientId = CommonUtils.getClientId(ctx.channel());
      if ((clientId == null)) {
        Thread.sleep(100);
        clientId = CommonUtils.getClientId(ctx.channel());
      }
      this.LOG.info(("执行了MQTT Subscribe 命令 : " + clientId));
      MqttSubscribeMessage subscribeMessage = ((MqttSubscribeMessage) mqttMessage);
      int messageId = subscribeMessage.variableHeader().messageId();
      ArrayList<TopicEntity> validTopicList = this.registerTopics(ctx, subscribeMessage.payload().topicSubscriptions());
      synchronized (validTopicList) {
        if (((validTopicList == null) || (validTopicList.size() == 0))) {
          this.LOG.info(String.format("Valid all subscribe topic failure,messageId:%s", Integer.valueOf(messageId)));
          return null;
        }
        SubAckEntity entity = new SubAckEntity(Integer.valueOf(messageId), validTopicList);
        this.LOG.info(entity.toString());
        PublishObservable.getInstance().start(clientId, IPublishObserver.Type.RETAIN);
        MqttMessage _response = new SubAckResponse().response(entity);
        return Collections.<MqttMessage>unmodifiableList(CollectionLiterals.<MqttMessage>newArrayList(_response));
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public synchronized ArrayList<TopicEntity> registerTopics(final ChannelHandlerContext ctx, final List<MqttTopicSubscription> topics) {
    synchronized (ctx) {
      String clientId = CommonUtils.getClientId(ctx.channel());
      ArrayList<TopicEntity> topicList = new ArrayList<TopicEntity>();
      for (final MqttTopicSubscription subscription : topics) {
        {
          String _picName = subscription.topicName();
          int _value = subscription.qualityOfService().value();
          final TopicEntity topic = new TopicEntity(_picName, _value);
          topic.setClientId(clientId);
          Perl5Util p5 = new Perl5Util();
          boolean _match = p5.match("/^[A-Za-z0-9]+([\\/A-Za-z0-9_]*|\\/\\+||\\/\\#)$/", topic.getName());
          if (_match) {
            PublishResponse _publishResponse = new PublishResponse();
            Publish publish = new Publish(topic, _publishResponse);
            PublishObservable.getInstance().register(clientId, publish);
          }
          topicList.add(topic);
        }
      }
      return topicList;
    }
  }
}
